## Progress Log

The following is a collection of notes and progress logs written throughout the development of Kitten Kerfuffle.

***

#### Day 1:

__Unknown__: Wrote a basic engine to handle events and drawing. Still needs some work, but it's a start. Also got started on some music (a first for me), as well as some art. I think I'll make a Tamagotchi clone called "Nekogotchi" ("neko" meaning "cat" in Japanese), because Mark likes cats. The art style I began with was very cartoon-like, but I think now I'll stick with 8x8 bitmaps instead. Drawing a cat will be tough.

***

#### Day 2:

__00:31__: I'm about to go to bed, but I wanted to log my progress from the last half hour. So I got to designing a cat in an 8x8 area using GIMP, and it didn't turn out so well. I actually ended up with something between a dog and a fox, depending on how you look at it. I added some shading (the kind I did for TINS 2016), and I really like it. I like it so much, in fact, that I think I'll incorporate dog/foxes into the game, too. Also added a cardboard box and some grass tiles. The grass will be recycled from my TINS 2016 entry, but with a few changes in color. The dog/fox thing has two-frame animation (TINS entry had zero animation, so this'll be new territory for me). Still need to add a cat...

__13:32__: Still haven't made a cat yet. Designed a few more tiles. The game looks like it takes place in autumn, which I like. I'm re-using the mushroom, grass, and bone tiles from my TINS 2016 entry, but have changed the colors a bit. I'm also experimenting with computer-generated voices to dub over the text boxes I will eventually implement. Not sure if I'll use them in the final product, however. I've changed my mind about the Tamagotchi clone idea; instead, you'll play as something (maybe the dog) and explore a little forest in search for a crazy cat lady's lost kittens. Thinking about adding a dark twist at the end where the lady eats the kittens... It's KrampusHack, after all. We'll see how it turns out...

__14:56__: Began designing the cat. It's actually turning out to look quite nice! I'm going with a cocoa color for the fur. Just need to add some shading and animation frames, and the cat'll be done! I think each cat will have a name from a table (like Cocoa, Brownie, etc). I wonder if I should have a mama cat go looking for her kittens as the goal, instead of a dog looking for a crazy cat lady's cats.

__17:06__: Designed and shaded the cat facing one direction. Not sure how I'll design the dog and cat looking up and down. This may look weird.

__17:53__: Got a map and camera class going. Just need to write the player class next, and it'll start to look like a game! I have two kinds of trees being generated: green ones and autumn-colored ones. The game mostly looks like it takes place in autumn, but the inclusion of green trees makes it look like autumn just began. I tried adding leaves here and there, but they didn't turn out too well. So that makes grass, mushrooms, and two kinds of trees that currently spawn. Not sure if I'll add bones. Don't want things to look too cluttered. I had an idea about giving the player powerups if they collect bones, but now I'm not sure. I have about a whole week to figure it out, so I'm not too worried about figuring it all out right now.

__22:08__: Started designing a house for the crazy cat lady to live in.

__23:20__: Scrapped the house. It didn't look good at all. Designed a front-facing cat, but it looked terrible. Designing good-looking tiles with only 64 pixels is tough. I think I'll just have two directions for the cats and dogs: left and right. That brings up and issue of also moving upward and downward, however; for example, how does the player know if the character is facing up or down if there is no visual representation for that? Because the map class generates tiles pseudo-randomly, I can't be sure if an animal will be trapped within trees. To accomodate for this, the player must be able to break down any barries. So, if you're playing as a dog, your bark would destroy nearby solid objects. I can get around the up and down issue by just having a bark destroy tiles in all directions of the player. That should work. Also, I added bones and flowers into the terrain generation, but it looks too cluttered, so I scrapped them. The terrain will only contain trees (green and brown) and mushrooms, as well as the player and cats. I also scrapped the cardboard box. Guess I'll cut all the useless tiles from the tilemap now, as well as design and shade the other facing directions for the animals.

***

#### Day 3:

__00:02__: Finished designing the cat. Added different shading for the other facing directions of the cat, to be a bit more "realistic"; not sure if I like the way it looks, though. Gotta see it in action before I make up my mind, I guess. I wonder if I should add different-looking cats, so each cat found will be unique. It'd be extra work, but would be pretty cool. Had to rewrite the tile codes for my tilemap in the map class, because I changed things around. I got rid of the tiny versions of each tree. I wonder if the cats should move around. Not sure I could do that with how I'm used to implementing collision detection. It sure would be sweet to see the cats move on their own though. Also considering adding sounds when near a cat. Like "3D sound" that you hear in a lot of first-person games. So the nearer you are to the source of the sound, the louder the sample becomes. If I go that route, I'm not sure I'll make it "3D" with the speakers. I got more computer-generated voices for the dog and cat. The cat goes "meow" in a deep voice. Using voices like these is totally unnecessary, but humorous, I think. The dog goes "bark", "woof", "ruff", and even "bork". Gotta cut them up and implement them once I write a player class. Began working on a configuration file, but quickly removed it. I don't want to deal with parsing a file for simple settings. I know the background music is named "annoying" for a reason, but the player will just have to be stuck with it.

__00:35__: I should get to bed soon, but oh well... I moved the dog and cat to their own PNG and XFC files. Not sure if I'll leave the GIMP XCF files when it comes time to submit, but I think I'll leave the FamiTracker files. I wonder if I should add an animation for when the dog barks (maybe using tinting instead)? Also wonder what to name the game (currently just "KrampusHack 2016"). Also, Mark likes cats... so should he play as the cat? I really like the idea of playing as a dog though. Maybe I'll make it an option at the end. Maybe the result of winning is you get to play as a cat. That'd be neat. I hope Mark'll be able to build and run the game! Oh, I also split up the dog sounds into separate files for later use. Gotta do the cat's sounds soon, too.

__19:00__: Found myself in troubled waters with the game today. I wanted to make a global instance of an RNG class that I could use between other classes. Externs didn't cut it. I spent several hours working on it, but finally settled on just passing a reference of an object and saving it to a local pointer member in each class. It sucks. It's messy. I don't like it. But it works. All the audio files are finished with for the cat and dog. I'm in the early stages of writing the cat class.

__19:15__: Made it so you can pipe in a seed when launching the game from a terminal. Spent a few minutes wondering why things didn't persist when using the same seed. Turned out I deleted a line of code earlier and forgot to put it back. Oops. At least now it works.

__19:19__: Set the camera to follow the cat for now. It didn't start panning until after the cat was well out of view. Gotta fix that.

__19:34__: Fixed. The issue was I didn't compensate for the display scale when calculating the view of the camera, among other little things.

__19:44__: It's bug-finding night, apparently. Couldn't get the size of a vector I passed by reference. When I tried, it'd segfault. Turned out I passed the map's tile vector to the cat class before I generated the tiles to begin with. Fixed now though.

__19:49__: The cat spawns in a random tile now. If it attempts to spawn in a solid tile, it'll retry until it finds a non-solid tile.

__19:58__: Man, this just isn't my day. The cat kept spawning in the same spot--sometimes in solids--and I didn't know why. The reason? I forgot to assign the cat's x and y position after deciding upon where to spawn it! >:(

__21:18__: No more bugs for now. Added keyboard inputs to the engine class. I should write a global class for collision detection and generic globals (enums, bitmap dimensions, etc).

__21:26__: Spoke too soon--found another bug: the map didn't render right, and caused a bunch of glitches to appear toward the southern border. I increased the map size, which fixed it, but at a cost--my old seeds are no more. :'( My favorite was 1482117618.

__22:15__: Discovered more camera and map-related issues and fixed them! The solid borders I have around the entire map are outside of the camera view, right? Well, I was using a tile that didn't actually exist, so when it came time for the map to draw the next tile out (which would be the border), it displayed garbage. I changed the border graphic to grass and the problem went away! Also, I changed the map size back to what it was before, which means I can use my favorite seed again! In other news, I have added "animation" (just two frames) to the cat! It looks a little odd that there's no up or down facing graphics, but it's whatever. The animation required I rearrange the tilemap for the cat. I'll do the same for the dog eventually. I want to get the cat to be locked in a grid-like movement, and to move on its own.

__22:49__: Added states, but haven't done anything with them yet. Removed all the fonts I had for the project. Total size uncompressed right now is 412K.

__23:22__: Made another song. This one sounds like an intro to an army game. I was going to use it for the intro state, but decided against it. It just doesn't fit. On the plus side, I devised a working title: "Kitten Kerfuffle". The tentative title before now was "Lucy's Lament" (Lucy would have been the cat lady's name). Tomorrow I need to: implement cat tile movement; spawn multiple cats; design HUD; create night time overlay; create dog class; figure out how collision will work. Good night!

***

#### Day 4:

__09:14__: It's cold outside! Added collision detection (per-tile basis) to the cat. Currently, the keyboard controls it. Soon it will move on its own, however. Also tweaked the animation a bit to work with per-tile movement. It's not perfect, but it works. Thinking about adding pumpkins to replace the mushrooms, but probably won't.

__09:27__: Cat moves on its own, but is running into walls. I'll have to make sure it checks for collision before deciding where to move next.

__09:46__: Cat now checks if next tile is solid, then decides not to move there. But now it looks "bouncy" because it moves so rapidly. I'll have to add a "cool down" timer.

__10:51__: Decided against adding a "cool down" timer. Added multiple cats. Need to change static variables to members. Lots of segfaults and freezing right now. :(

__10:58__: Changed static variables to members in the cat class. Also found the cause of the segfault: out of bounds array access. Game still freezes, and all of the cats move exactly the same. I need to figure out why they aren't moving independantly of one another.

__11:03__: Current problem: none of the cats are obeying collision any longer, and when one of the wanders out of bounds of the map, it results in a segfault. Solution: fix collision problem.

__11:25__: Changed cat object array to a vector. No change. Cats still disregard solid tiles. Also, I've decided the player will play as the cat, who then must find her kittens/cat friends. The main cat is named "Nini", in honor of my friend's cat.

__12:45__: Fixed the cat problem when moving left, right, and down. Issue still persists for moving up, for some odd reason. It turned out the cause for the issue was because the next tile in movement was assigned each "tick". This wasn't a problem when those variables were static. Even though I added a reset condition to fix this, moving up still has problems.

__13:31__: Found the problem: movement is based upon movement[4], with movement[0] being up; well, when it came time to stop moving, I had it set to movement[1] = false, instead of movement[0] = false. What a silly mistake! The cat moves around no problem now. I added back manual movement to debug it. Now I'll have to set it to automatic again.

__13:37__: It works! Multiples of the Cat class are created using a vector, and each obeys collision! This is fantastic! I added a quick "camera switcher"--I can switch between cat targets. :D

__15:01__: Left the game running for an hour to see if it'd crash. It didn't! Depending on how many kittens I make, I'll have to not render certain kittens if they aren't within the camera view. Gotta stress test it though.

__15:08__: Tried spawning 30 cats. Some seeds work no problem, but others freeze. To debug, I made it cout whenever a cat spawns. On seed 1482181376, it freezes. Turned out that some of the cats spawned outside of bounds, because when I did some basic bounds checking, it no longer freezes.

__15:57__: Added a special tint to each cat. Not sure if I'll keep it. It causes freezing sometimes.

__16:40__: Still not sure about freezing issues. Removed all tinting. Made it such that cats are only rendered if they are within camera view.

__16:46__: Seed 1482187412 dies after 61 loops. It's not loading related, so it must be related to update or rendering. I'll check.

__17:32__: So it's definitely the move() method that's causing the problem. I wonder if passing the map tiles has anything to do with it. Must dig deeper...

__19:07__: Played my hand at designing a kitten. It had a bigger head and a smaller body, to look cute. It didn't turn out well. I updated the dog's tile arrangement to match the cat's. Not sure if I'll use the dog. I'll probably cut a lot of content by the end. Current project size is 984K (no binaries included). Haven't fixed freezing issue yet.

__20:33__: If I remove the code that determines where/when the cat should move, the freezing no longer occurs. Getting close to a solution, I can feel it!

__20:35__: Holy cow, it worked! I just removed some redundant code and it all works! 1482187412 was the seed that had the issue (among others), and now it doesn't! I'll continue testing other seeds to be sure, but things are looking up! :D

__20:38__: So the so-called "redundant code" I removed a few moments ago was responsible for making the cat movement a little more realistic. See, the code checked if the next tile was solid before moving, which prevented the cat from running into walls, essentially. The reason it freaked out on certain seeds and not others is because it loops until there are no solid tiles before movement; however, if a cat spawns with solids on all sides, it can't escape this loop, thus freezing the game! Now I just need to think of a way to keep the functionality without freezing. I can't believe I've spent all day on this! I wonder how the other participants are doing.

__21:32__: So far I have had zero luck re-implementing the better cat movement without resulting in lock-ups. I may give it another shot later, but for now I am on to other things. I have 10 cats working right now, but I played around with 100. Even though the cats are only rendered individually if they are within the camera view, all of them are constantly being updated and moved. This really takes a lot of CPU power, which slows down the game. Actually, the game isn't slow, but the cats are. I think if I pass the camera's position to the move and update methods, and then check if they're within bounds, I can reduce much of the CPU usage. It's worth a shot, at least. I added randomly-selected names that appears above each cat in yellow. The selected name is consistent with its given seed. Not sure if I mentioned this already, but I also added a "Kittens found" HUD text. I originally threw it up there as "Kitty cam #_" for when I was switching between cats as targets (that functionality still exists--only the text has changed). I was thinking of adding a message dialog class, but I think I'll keep it simple by adding yellow floating text instead.

__21:43__: Cat movement is now only updated if the given cat is within the camera area. This has the unfortunate side effect of cats not moving until being seen, which diminishes some design quality, but comes at the added benefit of improved performance. Oh well, I guess I'll keep it like this for now (though I may revert to how it was earlier, depending on how I feel about it later). The game uses ~15.2 megs of memory, by the way. Next I have to work on making sure each cat doesn't collide with another one, as well as adding an intro dialog of some sort. Oh, and I still have to get started on the player class eventually!

***

#### Day 5:

__13:39__: Added the current time (in-game) to the HUD. Spent a good chunk of time wondering why al_draw_textf() wasn't working with my stringstream. Turned out I had to do stringstream.str().c_str() to get it to work (I didn't have that final .c_str() part before). I experimented with different colors (yellow and red), but I think white looks best for the HUD. I made it such that after a certain amount of time, the HUD would change from white to yellow, and ultimately red--to signify that time is short. I think the "story" of the game will be as follows: you, a mama cat named Nini, have lost your kittens. You must find them before dinner time (18:00/6pm). If you don't, your kittens won't get dinner (ramen noodles) and will starve to death. I'm throwing noodles in there because Mark said he wants "2. Noodles (as in like a bowl of Japanese-style ramen)". To do: 1) add losing sequence (don't find all kittens by dinner time); 2) devise plan for letting cat destroy tiles (the dog was going to use various barks/borks); 3) design noodle graphic (maybe make it a collectable?).

__14:30__: I created another cat. I think I'll make three designs in total. This one is half done, and will probably be used as the player cat.

__14:59__: Finished the second cat design. Cats now spawn with one of two total designs (although I'll add more later).

__18:42__: Tweaked the code responsible for hiding the rendering and updating of cats when outside of the camera area. If a cat left the view to the left or while going up, it would be prematurely clipped. Now it works just fine. I think I'll begin working on making sure the cats don't collide with one another now. This'll be tricky!

__18:52__: Found a bug in the cat class in how it was accessing tiles from the map class. I made a local scope vector for values from the map class' getTiles() method, and was trying to change values (because it was referenced). But I was only updating the local scope one the whole time. This explains why some cats were spawning in the same spot earlier. Now this is fixed.

__19:28__: The cats no longer collide or cross over one another. I achieved this by setting the current tile and next tile to solid whenever a cat moves. Then, when the cat stops moving (when it reaches its target tile), it sets the tile it came from to non-solid again, allowing things to pass through it. This results in no other cat colliding with the next cat's current or target movement tile. To top it all off, this works entirely off of the tilemap from the map class, which means it should be fairly easy to also implement into the player's class (when I finally get around to writing it)! :D

__19:40__: Every now and again, my game "skips" a few frames. I went digging into my update/render code, and it was totally messed up! What was I thinking a few days ago? I think it's better now though, after changing it up a bit. Hopefully there won't be any stutters. Anyway, I made the main update phase an else-if condition, so it goes inputs and then update. Render is its own deal. Not sure if that's how it should be, but whatever.

__19:45__: After a bit more testing, it looks like there's still some stuttering. I'll continue to play around with it, but it never occurs in the same spot twice, which leads me to believe it's just a "fluke".

__19:55__: If I remove my call to Engine.manageWindowEvents(), the stuttering stops. I guess I'll have to implement its functionality into the main file, rather than the engine (due to the conditionals).

__20:22__: Fixed it! I moved the window-specific events to the main conditional tree, and no more stuttering! :D I hope it doesn't come creeping back...

__22:46__: Ran the game for 2 hours (used this seed: 1482280618). No issues, so I'm happy. Time's quickly running out. I need to create the player, more cat designs, intro, ending, etc. Oh, I created some noodle graphics. About 10 of them spawn randomly per map. I'll probably increase that amount. I have two designs for the noodles. Not sure that I like either though. It looks more like a soup with a wooden ladle than anything else.

***

#### Day 6:

__00:08__: Onewing on the forums announced that the new submission deadline is the 26th. It's good to have extra time, though I don't know if I'll need it (let's hope not!). I added some introductory text. I still need to explain the controls and other mechanics, but I may do that through a README instead. Yeah, it's lazy, I know... The intro text even includes a reference to ramen noodles! I think I'll remove the actual noodles from the map. The introductory text took longer than expected to get right. I played around with a few different message box designs before ultimately going with a black background and white text. Nothing simpler than that!

__00:14__: Removed the ramen tile from spawning. It's still in the tile map PNG itself though. Time for bed now. In the morning: 1) roll-over checking for in-game time; 2) add losing condition; 3) actually make the player class; 4) day to night overlay; 5) remove junk code/files.

__09:38__: Added a readme file, written in Markdown. I'll change these progress updates to Markdown soon. I made sure the in-game clock rolls over back to 00:00 if it goes beyond 23:59, and also added a buffer zero if the hour is less than 10 (so it appears as 0x:xx instead of x:xx).

__10:05__: I added a losing screen. Once time runs out, the music and screen begin to fade, and then the losing screen appears. I still need to add something more than dummy text for the losing screen, and I need to make the intro fade, but this is a good start.

__10:19__: Added an MIT license file. Going to convert these progress logs to Markdown now.

__10:43__: The progress log is now in Markdown format. Next up: removing useless files.

__10:51__: Removed map directory (it was empty), dog.xcf, dog.png, all dog samples, and that extra song sample I made. Total project size: 336K.

__15:09__: Moved Nini's design to its own file. Made two temporary cat outlines in the cat bitmap. Now three kinds of cats spawn.

__16:00__: Added tinting back to the cats, but quickly scrapped it again. I might just have all the kittens look the same, to keep it simple.

__16:10__: The game will only feature one cat design, aside from the player cat, Nini.

__22:08__: Added real losing text. In the spirit of Krampus, the losing sequence is a bit dark. Also added dummy text for a winning sequence. The losing sequence uses red text, and the winning one currently uses random colors (trying to make it look like a rainbow, but I might use yellow in the end).

__22:12__: Changed winning text to yellow. Current project size is 340K. I'm not sure how I will use the individual kittens' names in-game. I tried displaying them on the winning/losing screens, but didn't like them there. I want to add music for winning and losing. Not sure I'll have enough time/talent to pull it off.

__22:42__: Intro text now fades out. It does so in half the time that it takes the other fades (winning and losing) do.

__22:46__: Tweaked the end of the losing text from "Press any key to end the misery." to "Press the escape key to end the misery." I did so in fear of the player missing the losing screen because they hit a key on accident as state was being changed.

__22:49__: Changed the losing text again to "Press escape to end your misery." The previous version trailed too far to the right for my liking. I might make the state texts fade with each screen, but maybe not. Here's what's left to do: write player class; create day-to-night overlay; think of a way to sneak the kitten names into the game; compose winning and losing music; a reward for winning the game.

***

#### Day 7:

__08:34__: Renamed the cat class to kitten class, and renamed all cat-related files to kitten-related ones. I'm about 85% finished with the game. I'm hoping to finish it by the day's end.

__09:07__: Finally began writing the player class, which is known as the Nini class in code. Nini spawns just like the cats do, and obeys all the same rules about collision. The movement is a little rough right now. I'll have to make it smoother. Also, the facing direction for left isn't working for some reason. Time to fix it.

__09:11__: Fixed the facing direction issue. It was caused by me mistakenly setting the wrong direction for left. Also noticed some of the shading was incomplete in Nini's animation frames, so I spruced that up. Now to make movement a bit smoother for Nini.

__09:20__: Ran a few tests and discovered why movement is rough-looking: it's because Nini hangs out in the same tile between movements for two frames (one on rest and one on resuming movement); this results in a sort of frame-skipping look. I need to fix this.

__09:48__: Still no luck with fixing the jittery movement. If I remove the reset code, it the jitteriness goes way, but that results in movement never stopping.

__10:04__: Fixed it. The issue was not with the Nini class nor its movement code, but rather when I was updating the camera. I was updating the camera before its target was being updated, which resulted in jittery movement. I am glad that is fixed. Next up will be a day-to-night overlay. Also, I am considering adding enemies into the game, but I am not sure if it will be necessary. Perhaps I could use the dog I designed much earlier to serve as an enemy.

__10:28__: The day-to-night overlay has been added. It begins at 17:00 and slowly grows dark until 18:00. I wonder if six minutes is long enough to find all of the kittens. I need to let Nini use a mighty meow to break down barriers in her way, so she can more easily traverse the landscape.

__10:33__: Do you know what would be cool? If there were a HUD item that indicated how many tiles away you were from the nearest kitten. Maybe it could be activated using an item? Also, I am experiencing more frame skipping. I am not sure if it is my game or my computer. Sometimes a long up time can result in oddities, but my up time is only a little more than a day.

__11:21__: The game now prints out the shortest distance between you and the nearest kitten. It has some bugs right now (like sometimes it does not display the nearest one for some reason), but I am working on it. This is the current seed I am using for debugging purposes: 1482427239.

__11:24__: Fixed the distance bug I mentioned. It was happening because I was using unsigned integers, which of course do not allow for negatives. Changing it to a signed integer allows the distance formula to work just fine now. I will now work on adding this nearest distance to the HUD.

__11:29__: I had several calculations being performed in the main render loop. I moved them to the update phase instead.

__11:33__: Added a HUD item for displaying the number of tile spaces between Nini and the nearest kitten. I'll spruce it up later. Moved facing direction updates from each kitten's render method to their update one.

__11:43__: Updated the HUD. Now all items are on the top left side of the screen. I'm not quite pleased with it yet though. I may revert to how it was previously with the kitten counter on the left and the current time on the right. I'm not sure how I will display the nearest distance to a kitten. For now, the nearest kitten and its name are displayed on the HUD, which is neat; it reads "Nearby (Cheese): 7" to mean that Cheese is a distance of 7 away.

__13:55__: I am now working on allowing Nini to break through her surroundings to reach her kittens. I found that kittens that spawn are not protected from collision before their first move. So kittens that spawn surrounded by solids will not be solid themselves. I think I fixed that though by making their first tile solid when they spawn.

__14:12__: Nini can break through solids (so long as they are not generated by the kittens) on her left and right sides. I will soon add the same functionality to above and below her. I found a bug in the "nearby kitten" code. If two kittens are equally as near to Nini, the name that is selected may be wrong. I changed the condition for selecting the name, and now it seems to work. I will have to keep an eye on it though.

__14:20__: Nini can now break solids on all four adjacent tiles (above, below, to the left, and to the right of her). I added the letter "m" next to the nearby kitten distance thing; this signifies meters. Each tile will be considered a single meter square. Each map is 192x96 tiles, or 18,432 total tiles/meters in area (correct me if I'm wrong). All that's left now is to add a sound effect each time Nini breaks solids (probably a might meow sound), as well as add a visual effect (like tinting) to the affected tiles. I might also add a "cooldown" between meows.

__14:53__: Nini now becomes darker for 1/6th a second and meows deeply to break nearby solids. I'm not sure if I'll keep the darker tinting or make it red, and I'm not too keen on hearing a computer-generated meow every time I hit the action key, so I might change it. I also want to add "left over" graphics for each destroyed tile. For example, if Nini destroys an autumn-colored tree, in its place should be some leaves or debris.

__15:08__: Replaced Nini's computer-generated meow with one I found on SoundBible.com. I need to adjust its volume though. I also updated the README.md file to include a few credits and how to play.

__15:20__: I tried another meow sound, but it's annoying. I think I might just use a blip for the meow instead.

__15:58__: Decided to re-use the hit sound effect from my TINS 2016 entry, Mori, for when the solids are destroyed. I will have to also allow Nini to actually "find" her kittens (when the action key is hit near a kitten, it will be "found"); I want the kitten to purr or meow upon being found. Maybe a heart could appear overhead when a kitten is found. Changed error message when a condition fails in the engine class. Decided to stick with black for the meow tint. There's currently a bug with the hit sound effect going off. Not sure why, but it only works once or twice, then never again.

__16:18__: Audio sample issue persists. Not sure why. I brought the display names above each kitten back, and made the font a bit smaller (hurray for transformations). I also moved the nearby kitten thing above Nini's head. It now only displays the distance in meters, rather than also including the kitten's name. I need to adjust the rendering for the kittens' names, as they only pop into view abruptly after the kittens themselves do.

__16:32__: Updated the README.md file again to give more information about the distance tracker and controls. I also renamed the binary from "krampus" to "kerfuffle".

__20:08__: I adjusted how the kittens' names are rendered. They now come into view smoothly, and do not "pop in" out of the blue. Also, I toyed with the idea of making a lighter kitten design for the female-named kittens, but ultimately opted against it.

__20:24__: Nini can now "find" kittens if she meows at them (if the kitten is to the left of her). I'll make it work for the remaining sides soon. Also, I noticed that the kitten name text still "pops in" from the left and right side. Gotta fix that!

__20:27__: Fixed the kitten name text popping in.

__20:29__: Nini now finds kittens from any adjacent tiles. I need to come up with a sound effect for collecting the kittens.

__20:30__: Houston, we have a problem. Upon finding a kitten and "collecting" it, the distance between Nini and the nearest kitten is not updated.

__20:35__: I fixed the aforementioned problem by setting the distance variable to 999 before each calculation. Previously, it was set to the first kitten's distance; however, this resulted in subsequent kittens from being updated if the first kitten has been found and is the nearest one. Now it's fixed though. Oh, and I finished the game for the very first time by finding all the kittens! I followed the HUD to the kittens and "won" after 210 seconds of playing. After finding the final cat, the distance HUD item went to 999. I need to make sure it either goes away or sticks to 0. Oh, and I still need to finish the winning text and add a cool down to the meows, among other things.

__20:54__: The kitten distance counter now reads "0m" when there are no more kittens to find. I'm thinking about letting that counter be togglable. I find myself looking at the numbers rather than the rest of the game. I did this in the Assassin's Creed games, too--rather than look at the lovely world around me, I would instead keep my eyes fixed on the mini map (I now play most games with the mini map disabled, if possible). Maybe the "T" key could be used to toggle it. I wonder if I should toggle the kittens' names, too.

__21:01__: The "T" key now toggles between displaying the distance to the nearest kitten as well as each kitten's name. It is toggled off by default.

__21:03__: Updated README.md to include the toggle feature. I'm done for the day. What's left: meow cool down; fix sound bug; add sound effect for meowing and for kittens being found; finish winning text; add credits state to show KrampusHack 2016 participants and their avatars (will probably use Edgar's code for that). Home stretch!

***

#### Day 8:

__10:52__: I'm hoping to finish today. I added a cool down timer between meows, and removed the crunch sound effect. I'm using a crunchy sound for the meow now that was generated using [sfxr](http://www.drpetter.se/project_sfxr.html). My earlier intention was to use a blip sound, but in practice that was far too obnoxious. Still going back and forth with the nearest kitten meter; not sure if I like it above Nini's head, or if I like it with a toggle, or if I want it in the normal HUD (space is limited though). Here's what I want to do today: (1) finish winning text; (2) add credits with participants; (3) add sound effect for when a kitten is found; (4) settle on where to place the nearest kitten meter.

__11:04__: I settled on a placement for that final HUD item: lower left corner of the screen. It is always displayed, but the floating kitten names are togglable and off by default. Also, in case I did not mention previously, yesterday evening I had some help from a friend in regards to making some new kitten names. Those new names are: Bub and Mimi. Also, I noticed something shortly after finishing the game: the last kitten's name persists upon winning. This is fine. I'll keep it like that.

__12:45__: Been doing a little bit of polishing up and removing junk code. I made each of the kittens meow using a temporary sound effect (I'll add a real one soon). Doing so made the game take a second or two to load upon being executed. This was because it had to load and check each sample for each kitten. I instead loaded a single sample and have it passed to each kitten, which cut the memory consumption in half. I think I'll do the same for the kittens' bitmap next.

__12:56__: Each kitten now has its bitmap passed to it, rather than each creating its own. This, in addition to do the same for its samples, has reduced the game's memory consumption from ~40MB to ~15MB. The game no longer takes a second or so to load. Here's what's left to do: (1) winning text; (2) kitten found sound effect; (3) credits; (4) maybe left overs placed whenever a tile is destroyed.

__14:19__: The winning text is complete! It flashes, too. Not a vibrantly as I'd like, but this will suffice.

__17:36__: Began working on the credits. It currently only displays "KrampusHack 2016" and scrolls. I need to add each of the participants and maybe their avatars, then have the game close.

__17:45__: I'll use Edgar's avatar pack for the credits. I have to make a few tweaks to his code (mostly changing file paths).

__17:59__: Having difficulties with Edgar's code. It would fail to load Takaaki's avatar each time, because the PNG file for Takaaki was misspelled. Fixed that, but now it just hangs after calling PopulateAvatars().

__18:04__: Fixed bug with Nini making her meow sound outside of the appropriate state. Still having issues with Edgar's code. If I can't get it to work, I just won't use it. I'd love to use it though.

__19:27__: Well, I'm not sure about Edgar's code. I don't want to spend too much time on it, so I'm scrapping it for now.

__19:51__: Credits are finished with. All that is left now is to make a blip for the kittens' meow, and I'll be done (hopefully)!

__19:56__: Kittens now have a blip for their "meow". Directory size without binaries: 360K; with binaries and object files: 756K. I noticed a few things just now: the intro screens encourages the player to press any key to continue, but pressing the escape key during this state just goes to the credits. I might change that. Also, destroying adjacent tiles from Nini is easiest from the left and top sides, as that is where the origin is. I _could_ change it to work from Nini's center as the origin, but I probably won't for something so insignificant.

__19:59__: Pressing the escape key now does nothing on the first state. I will do a few last minute tests to make sure the game works, and then I'll be done.

__20:06__: Found a bug in the losing sequence text. Some text is overlapping. Working on it now.

__20:09__: Fixed aforementioned bug. Also, pressing escape at the intro sequence now moves to the next state. Finally, I moved the "special thanks" section down a bit. I'm done.

__20:19__: Guess I wasn't done after all. I added the ramen graphic to the very end of the credits. I know it turned out to resemble a bowl of soup more than anything, but I figure I shouldn't let it go to waste, so I threw it in there. Here are some things I didn't get done: powerups, enemies, fading text, and music for the different states. Oh well. Done now!
